/*
  DRIVE:SH1106,&SSD1306
  RESOLUTION:96*39
  INTERFACE:4W SPI
  TEST SYSTEM:ARDUINO UNO
  VOLTAGE:3.3V
  SCK-->PIN 13
  MISO-->PIN 12
  MOSI-->PIN 11
  OLED_CS-->PIN 10
  OLED_DC-->PIN 9
  OLED_RST-->PIN 8
  SD_CS-->PIN 7

  VER 1.0,2020.11.11
*/

#include <Arduino.h>
#include <U8g2lib.h>

#ifdef U8X8_HAVE_HW_SPI
#include <SPI.h>
#endif
#ifdef U8X8_HAVE_HW_I2C
#include <Wire.h>
#endif


/*
  U8g2lib Example Overview:
    Frame Buffer Examples: clearBuffer/sendBuffer. Fast, but may not work with all Arduino boards because of RAM consumption
    Page Buffer Examples: firstPage/nextPage. Less RAM usage, should work with all Arduino boards.
    U8x8 Text Only Example: No RAM usage, direct communication with display controller. No graphics, 8x8 Text only.

*/

U8G2_SH1106_128X64_NONAME_F_4W_HW_SPI u8g2(U8G2_R0, /* cs=*/ 10, /* dc=*/ 9, /* reset=*/ 8);

// End of constructor list


void u8g2_prepare(void) {
  u8g2.setFont(u8g2_font_6x10_tf);
  u8g2.setFontRefHeightExtendedText();
  u8g2.setDrawColor(1);
  u8g2.setFontPosTop();
  u8g2.setFontDirection(0);
}

void u8g2_box_frame(uint8_t a) {
  //  u8g2.drawStr( 0, 0, "drawBox");
  u8g2.drawBox(80, 40, 20, 10);       //2020.11.11
  u8g2.drawBox(100 + a, 45, 30, 7);
  //  u8g2.drawStr( 0, 30, "drawFrame");
  u8g2.drawFrame(30, 10 + 30, 20, 10);
  u8g2.drawFrame(40 + a, 15 + 30, 30, 7);
}

void u8g2_disc_circle(uint8_t a) {
  //  u8g2.drawStr( 0, 0, "drawDisc");
  u8g2.drawDisc(80, 14 + 30, 9);      //2020.11.12
  u8g2.drawDisc(88 + a, 14 + 30, 7);
  //  u8g2.drawStr( 0, 30, "drawCircle");
  u8g2.drawCircle(40, 14 + 30, 9);    //2020.11.12
  u8g2.drawCircle(48 + a, 14 + 30, 7);
}

void u8g2_r_frame(uint8_t a) {
  u8g2.drawStr( 0, 0, "drawRFrame/Box");
  u8g2.drawRFrame(32, 25, 40, 30, a + 1);
  u8g2.drawRBox(85, 25, 25, 30, a + 1);
}

void u8g2_string(uint8_t a) {
  u8g2.setFontDirection(0);
  u8g2.drawStr(30 + a, 31, " 0");
  u8g2.setFontDirection(1);
  u8g2.drawStr(30, 31 + a, " 90");
  u8g2.setFontDirection(2);
  u8g2.drawStr(30 - a, 31, " 180");
  u8g2.setFontDirection(3);
  u8g2.drawStr(30, 31 - a, " 270");
}

void u8g2_line(uint8_t a) {
  //  u8g2.drawStr( 0, 0, "drawLine");
  u8g2.drawLine(35 + a, 25, 30, 120);    //2020.11.12
  u8g2.drawLine(35 + a * 2, 25, 60, 120);
  u8g2.drawLine(35 + a * 3, 25, 90, 120);
  u8g2.drawLine(35 + a * 4, 25, 120, 120);
}

void u8g2_triangle(uint8_t a) {
  uint16_t offset = a;
  u8g2.drawStr( 0, 0, "drawTriangle");
  u8g2.drawTriangle(14, 7, 45, 30, 10, 40);
  u8g2.drawTriangle(14 + offset, 7 - offset, 45 + offset, 30 - offset, 57 + offset, 10 - offset);
  u8g2.drawTriangle(57 + offset * 2, 10, 45 + offset * 2, 30, 86 + offset * 2, 53);
  u8g2.drawTriangle(10 + offset, 40 + offset, 45 + offset, 30 + offset, 86 + offset, 53 + offset);
}

void u8g2_ascii_1() {
  char s[2] = " ";
  uint8_t x, y;
  //  u8g2.drawStr( 0, 0, "ASCII Show");
  for ( y = 0; y < u8g2.getHeight() / 8; y++ ) {
    for ( x = 0; x < u8g2.getWidth() / 8; x++ ) {
      s[0] = y * 8 + x + 4;                        //2020.11.10
      u8g2.drawStr(x * 8, y * 8 , s);
    }
  }
}
/*
  void u8g2_ascii_2() {
  char s[2] = " ";
  uint8_t x, y;
  u8g2.drawStr( 0, 0, "ASCII page 2");
  for ( y = 0; y < u8g2.getHeight() / 8; y++ ) {
    for ( x = 0; x < u8g2.getWidth() / 8; x++ ) {
      s[0] = y *4 + x + 96;
      u8g2.drawStr(x * 8, y * 8 + 10, s);
    }
  }
  }
*/
void u8g2_extra_page(uint8_t a)
{
  u8g2.drawStr( 32, 25, "Unicode");
  u8g2.setFont(u8g2_font_unifont_t_symbols);
  u8g2.setFontPosTop();
  u8g2.drawUTF8(32, 36, "☀ ☁");
  switch (a) {
    case 0:
    case 1:
    case 2:
    case 3:
      u8g2.drawUTF8(a * 3 + 32, 36 + 16, "☂");
      break;
    case 4:
    case 5:
    case 6:
    case 7:
      u8g2.drawUTF8(a * 3 + 32, 36 + 16, "☔");
      break;
  }
}

#define cross_width 24
#define cross_height 24
static const unsigned char cross_bits[] U8X8_PROGMEM  = {
  0x00, 0x18, 0x00, 0x00, 0x24, 0x00, 0x00, 0x24, 0x00, 0x00, 0x42, 0x00,
  0x00, 0x42, 0x00, 0x00, 0x42, 0x00, 0x00, 0x81, 0x00, 0x00, 0x81, 0x00,
  0xC0, 0x00, 0x03, 0x38, 0x3C, 0x1C, 0x06, 0x42, 0x60, 0x01, 0x42, 0x80,
  0x01, 0x42, 0x80, 0x06, 0x42, 0x60, 0x38, 0x3C, 0x1C, 0xC0, 0x00, 0x03,
  0x00, 0x81, 0x00, 0x00, 0x81, 0x00, 0x00, 0x42, 0x00, 0x00, 0x42, 0x00,
  0x00, 0x42, 0x00, 0x00, 0x24, 0x00, 0x00, 0x24, 0x00, 0x00, 0x18, 0x00,
};

#define cross_fill_width 24
#define cross_fill_height 24
static const unsigned char cross_fill_bits[] U8X8_PROGMEM  = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 0x64, 0x00, 0x26,
  0x84, 0x00, 0x21, 0x08, 0x81, 0x10, 0x08, 0x42, 0x10, 0x10, 0x3C, 0x08,
  0x20, 0x00, 0x04, 0x40, 0x00, 0x02, 0x80, 0x00, 0x01, 0x80, 0x18, 0x01,
  0x80, 0x18, 0x01, 0x80, 0x00, 0x01, 0x40, 0x00, 0x02, 0x20, 0x00, 0x04,
  0x10, 0x3C, 0x08, 0x08, 0x42, 0x10, 0x08, 0x81, 0x10, 0x84, 0x00, 0x21,
  0x64, 0x00, 0x26, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

#define cross_block_width 14
#define cross_block_height 14
static const unsigned char cross_block_bits[] U8X8_PROGMEM  = {
  0xFF, 0x3F, 0x01, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x20,
  0xC1, 0x20, 0xC1, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x20,
  0x01, 0x20, 0xFF, 0x3F,
};

//show bit bmp
#define bmp_width 128
#define bmp_height 32
static const unsigned char bmp_bits[] U8X8_PROGMEM  = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x03, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0xfc, 0x77, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0xf4, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x03, 0x43, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0xfc, 0x20, 0x70, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x80, 0xff, 0x0c, 0x80, 0x30, 0x9f, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x40, 0xfe, 0x14, 0xf8, 0xf7, 0xf7, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xe0, 0xfd, 0xed, 0xe5, 0xef, 0x1f, 0x1c, 0x00, 0xfe, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xa0, 0xfd, 0x1f, 0xde, 0xdf, 0x00, 0x60, 0x00, 0xf9, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0xfb, 0x03, 0xda, 0x1f, 0x7f, 0x80, 0x80, 0xf7, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0xfb, 0x17, 0xb1, 0xff, 0xab, 0x01, 0x81, 0xf6, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0xfb, 0x0f, 0xb1, 0x7f, 0x5f, 0x07, 0x42, 0xec, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0xfb, 0x2f, 0xb1, 0xff, 0xbb, 0x0a, 0xfc, 0xeb, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0xfb, 0x1f, 0xb1, 0xff, 0xff, 0x17, 0xc4, 0xeb, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0xfb, 0x5b, 0xb1, 0x3f, 0xf0, 0xff, 0xc3, 0xff, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xa0, 0xfd, 0xf1, 0xb1, 0x7f, 0x80, 0x7f, 0xc2, 0xe0, 0x0c, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xe0, 0xfd, 0xf9, 0xb1, 0x7f, 0x7f, 0xcf, 0x7f, 0x40, 0x0c, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x40, 0xfe, 0xfe, 0xda, 0x5f, 0x00, 0x10, 0x80, 0x9f, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x80, 0x7f, 0x00, 0xde, 0xcf, 0xff, 0xff, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0x7f, 0xf8, 0x4f, 0xfc, 0xff, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x07, 0x00, 0x00, 0x00, 0xf9, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

};

void u8g2_bitmap_overlay(uint8_t a) {
  uint8_t frame_size = 28;

  u8g2.drawStr(0, 0, "Bitmap overlay");

  u8g2.drawStr(0, frame_size + 12, "Solid / transparent");
  u8g2.setBitmapMode(false /* solid */);
  u8g2.drawFrame(0, 10, frame_size, frame_size);
  u8g2.drawXBMP(2, 12, cross_width, cross_height, cross_bits);
  if (a & 4)
    u8g2.drawXBMP(7, 17, cross_block_width, cross_block_height, cross_block_bits);

  u8g2.setBitmapMode(true /* transparent*/);
  u8g2.drawFrame(frame_size + 5, 10, frame_size, frame_size);
  u8g2.drawXBMP(frame_size + 7, 12, cross_width, cross_height, cross_bits);
  if (a & 4)
    u8g2.drawXBMP(frame_size + 12, 17, cross_block_width, cross_block_height, cross_block_bits);
}

void u8g2_bitmap_modes(uint8_t transparent) {
  const uint8_t frame_size = 24;  //2020.11.04,24

  u8g2.drawBox(0, frame_size * 0.5 , frame_size * 5.25, frame_size);  //2020.11.10
  u8g2.drawStr(frame_size * 0.5, 50, "Black");
  u8g2.drawStr(frame_size * 2, 50, "White");
  u8g2.drawStr(frame_size * 3.5, 50, "XOR");

  if (!transparent) {
    u8g2.setBitmapMode(false /* solid */);
    u8g2.drawStr(0, 0, "Solid bitmap");
  } else {
    u8g2.setBitmapMode(true /* transparent*/);
    u8g2.drawStr(0, 0, "Transparent bitmap");
  }
  u8g2.setDrawColor(0);// Black
  u8g2.drawXBMP(frame_size * 0.5, 24, cross_width, cross_height, cross_bits);
  u8g2.setDrawColor(1); // White
  u8g2.drawXBMP(frame_size * 2, 24, cross_width, cross_height, cross_bits);
  u8g2.setDrawColor(2); // XOR
  u8g2.drawXBMP(frame_size * 3.5, 24, cross_width, cross_height, cross_bits);
}

void Show_PIC()
{
  u8g2.drawXBMP(15, 25, bmp_width, bmp_height, bmp_bits);
}

uint8_t draw_state = 0;

void draw(void) {
  u8g2_prepare();
  switch (draw_state >> 3) {
    case 0: u8g2_ascii_1(); break;
    //    case 1: u8g2_ascii_2(); break;
    case 1: u8g2_box_frame(draw_state & 7); break;
    case 2: u8g2_disc_circle(draw_state & 7); break;
    case 3: u8g2_r_frame(draw_state & 7); break;
    //    case 4: u8g2_string(draw_state&7); break;
    case 5: u8g2_line(draw_state & 7); break;
    //    case 6: u8g2_triangle(draw_state&7); break;
    case 6: u8g2_extra_page(draw_state & 7); break;
    case 7: Show_PIC();  break;
      delay(1500);
      /*    case 8: u8g2_bitmap_modes(0); break;
          case 9: u8g2_bitmap_modes(1); break;
          case 10: u8g2_bitmap_overlay(draw_state&7); break;*/
  }
}


void setup(void) {
  u8g2.begin();
}

void loop(void) {
  // picture loop
  u8g2.clearBuffer();
  draw();
  u8g2.sendBuffer();

  // increase the state
  draw_state++;
  if ( draw_state >= 16 * 8 ) //2020.11.04,12*8
    draw_state = 0;

  // deley between each page
  delay(100);

}
