
//BMP Picture in SD
//BMP name maybe logo.bmp,,PIC_240320_1.bmp,PIC_240320_2.bmp,PIC_240320_3.bmp,PIC_240320_4.bmp,PIC_240320_5.bmp,PIC_240320_6.bmp,PIC_240320_7.bmp,PIC_240320_8.bmp
/****************************************
  PIN DEFINE
  VCC-->3.3V
  GND-->GND
  SCK-->PIN 13
  MISO-->PIN 12
  MOSI-->PIN 11
  TFT_CS-->PIN 10
  TFT_DC-->PIN 9
  TFT_RST-->PIN 8
  SD_CS-->PIN 7
  TFT_BL-->PIN 6
 ***************************************/
#include <Adafruit_GFX.h>         // Core graphics library
#include <Adafruit_ST7789.h>     // Hardware-specific library
#include <SdFat.h>                // SD card & FAT filesystem library
#include <Adafruit_SPIFlash.h>    // SPI / QSPI flash library
#include <Adafruit_ImageReader.h> // Image-reading functions

#define delay_Dis 2000

// Comment out the next line to load from SPI/QSPI flash instead of SD card:
#define USE_SD_CARD

// TFT display and SD card share the hardware SPI interface, using
// 'select' pins for each to identify the active device on the bus.

#define TFT_CS 10
#define TFT_DC 9
#define TFT_RST 8
#define SD_CS 7
#define TFT_BL 6
#define delay_Dis 2000

#if defined(USE_SD_CARD)
SdFat                SD;         // SD card filesystem
Adafruit_ImageReader reader(SD); // Image-reader object, pass in SD filesys
#else
// SPI or QSPI flash filesystem (i.e. CIRCUITPY drive)
#if defined(__SAMD51__) || defined(NRF52840_XXAA)
Adafruit_FlashTransport_QSPI flashTransport(PIN_QSPI_SCK, PIN_QSPI_CS,
    PIN_QSPI_IO0, PIN_QSPI_IO1, PIN_QSPI_IO2, PIN_QSPI_IO3);
#else
#if (SPI_INTERFACES_COUNT == 1)
Adafruit_FlashTransport_SPI flashTransport(SS, &SPI);
#else
Adafruit_FlashTransport_SPI flashTransport(SS1, &SPI1);
#endif
#endif
Adafruit_SPIFlash    flash(&flashTransport);
FatFileSystem        filesys;
Adafruit_ImageReader reader(filesys); // Image-reader, pass in flash filesys
#endif

// Use hardware SPI (on Uno, #13, #12, #11) and the above for CS/DC
Adafruit_ST7789 tft = Adafruit_ST7789(TFT_CS, TFT_DC, TFT_RST);
// If using the breakout, change pins as desired
//Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC, TFT_MOSI, TFT_CLK, TFT_RST, TFT_MISO);
Adafruit_Image       img;        // An image loaded into RAM
int32_t              width  = 0, // BMP image dimensions
                     height = 0;
void SPI_WriteCommm(byte byInst)
{
  digitalWrite(TFT_CS, LOW);
  digitalWrite(TFT_DC, LOW);
  SPI.transfer(byInst);
  //  delay(1);
  digitalWrite(TFT_CS, HIGH);

  //  delay(1);
}

void SPI_WriteData(word byData)
{
  digitalWrite(TFT_CS, LOW);
  digitalWrite(TFT_DC, HIGH);
  SPI.transfer(byData);
  //  delay(1);
  digitalWrite(TFT_CS, HIGH);

  //  delay(1);
}
//ST7789,2.0" IPS PANEL,240(RGB)*320,Initialization
void LCD_Init() {
  /* //---------------------------------------------------------------------------------------------------//
    SPI_WriteCommm(0x11);
    delay(120); //Delay 120ms
    //-----------------------------------------RGB seting ------------------------------------------//
    SPI_WriteCommm(0xB0);
    SPI_WriteData(0x00);
    SPI_WriteData(0xF0);

    SPI_WriteCommm(0xB1);
    SPI_WriteData(0x00);//0x40
    SPI_WriteData(0x02);
    SPI_WriteData(0x14);
  */
  /*
    SPI_WriteCommm(0xE9);
    SPI_WriteData(0x03);//0x40
    SPI_WriteData(0x03);
    SPI_WriteData(0x02);

    SPI_WriteCommm(0xE8);
    SPI_WriteData(0x2A);//0x40
    SPI_WriteData(0x2B);
    SPI_WriteData(0x10);
    SPI_WriteData(0x15);
  */
  //---------------------------------------------------------------------------------------------------//
  delay(120);                //Delay 120ms

  SPI_WriteCommm(0x21);

}
///End Initialization

void setup(void) {
  pinMode(TFT_DC, OUTPUT);
  pinMode(TFT_CS, OUTPUT);
  pinMode(TFT_RST, OUTPUT);
  pinMode(TFT_BL, OUTPUT);
  pinMode(SD_CS, OUTPUT);
  ImageReturnCode stat; // Status from image-reading functions

  Serial.begin(9600);
  /*
    #if !defined(ESP32)
    while(!Serial);       // Wait for Serial Monitor before continuing
    #endif
  */
  SPI.setDataMode(3);
  SPI.setClockDivider(4);

  digitalWrite(TFT_RST, HIGH);
  delay(10);
  digitalWrite(TFT_RST, LOW);
  delay(100);
  digitalWrite(TFT_RST, HIGH);
  delay(50);

  tft.init(135, 240);           // Init ST7789 320x240
  digitalWrite(TFT_BL, HIGH);   //OPEN BACKLIGHT
  LCD_Init();
  // The Adafruit_ImageReader constructor call (above, before setup())
  // accepts an uninitialized SdFat or FatFileSystem object. This MUST
  // BE INITIALIZED before using any of the image reader functions!
  Serial.print(F("Initializing filesystem..."));

  stat = reader.loadBMP("/PIC1.bmp", img);



#if defined(USE_SD_CARD)
  // SD card is pretty straightforward, a single call...
  if (!SD.begin(SD_CS, SD_SCK_MHZ(25))) { // ESP32 requires 25 MHz limit
    Serial.println(F("SD begin() failed"));
    for (;;); // Fatal error, do not continue
  }
#else
  // SPI or QSPI flash requires two steps, one to access the bare flash
  // memory itself, then the second to access the filesystem within...
  if (!flash.begin()) {
    Serial.println(F("flash begin() failed"));
    for (;;);
  }
  if (!filesys.begin(&flash)) {
    Serial.println(F("filesys begin() failed"));
    for (;;);
  }
#endif
  Serial.println(F("OK!"));

  Serial.println(F("OK!"));
  // Fill screen blue. Not a required step, this just shows that we're
  // successfully communicating with the screen.
  //   tft.fillScreen(ILI9341_BLUE);

  // Load full-screen BMP file 'purple.bmp' at position (0,0) (top left).
  // Notice the 'reader' object performs this, with 'tft' as an argument.
  //  Serial.print(F("Loading purple.bmp to screen..."));
  //stat = reader.drawBMP("/purple.bmp", tft, 0, 0);
  /*
    Serial.print(F("Loading PIC1.bmp to screen..."));
    stat = reader.drawBMP("/PIC1.bmp", tft, 0, 0);
    reader.printStatus(stat);   // How'd we do?

    reader.drawBMP("/PIC2.bmp", tft, 0, 0);
    delay(2000);
    //  reader.drawBMP("/PIC1.bmp", tft, 0, 0);
    //  delay(2000);
    reader.drawBMP("/PIC3.bmp", tft, 0, 0);
    delay(2000);
    reader.drawBMP("/PIC4.bmp", tft, 0, 0);
    delay(2000);
  */
  // Query the dimensions of image 'parrot.bmp' WITHOUT loading to screen:
  Serial.print(F("Querying parrot.bmp image size..."));
  //  stat = reader.bmpDimensions("/parrot.bmp", &width, &height);
  stat = reader.bmpDimensions("/PIC1.bmp", &width, &height);
  reader.printStatus(stat);   // How'd we do?
  if (stat == IMAGE_SUCCESS) { // If it worked, print image size...
    Serial.print(F("Image dimensions: "));
    Serial.print(width);
    Serial.write('x');
    Serial.println(height);
  }

  // Load small BMP 'wales.bmp' into a GFX canvas in RAM. This should fail
  // gracefully on Arduino Uno and other small devices, meaning the image
  // will not load, but this won't make the program stop or crash, it just
  // continues on without it. Should work on Arduino Mega, Zero, etc.
  //  Serial.print(F("Loading wales.bmp to canvas..."));
  //  stat = reader.loadBMP("/wales.bmp", img);
  //  stat = reader.loadBMP("/PIC1.bmp", img);
  //  reader.printStatus(stat); // How'd we do?

  //  delay(2000); // Pause 2 seconds before moving on to loop()
}

void loop() {
//   testFrame(ST77XX_RED);
//    delay(delay_Dis);
    testFillScreen();
    delay(delay_Dis);
    testBand();
    delay(delay_Dis);
//    testGrayHor16();
//    delay(delay_Dis);
  
  //  Serial.print(F("Loading PIC1.bmp to screen..."));
  //  stat = reader.drawBMP("/PIC1.bmp", tft, 0, 0);
  //  reader.printStatus(stat);   // How'd we do?

  reader.drawBMP("/NOTE_135240_1.bmp", tft, 0, 0);
  delay(8000);
  reader.drawBMP("/logo_135240.bmp", tft, 0, 0);
  delay(2000);
  reader.drawBMP("/PIC_135240_1.bmp", tft, 0, 0);
  delay(2000);
  reader.drawBMP("/PIC_135240_2.bmp", tft, 0, 0);
  delay(2000);
  reader.drawBMP("/PIC_135240_3.bmp", tft, 0, 0);
  delay(2000);
  reader.drawBMP("/PIC_135240_4.bmp", tft, 0, 0);
  delay(2000);
  reader.drawBMP("/PIC_135240_5.bmp", tft, 0, 0);
  delay(2000);
  reader.drawBMP("/PIC_135240_6.bmp", tft, 0, 0);
  delay(2000);
  reader.drawBMP("/PIC_135240_7.bmp", tft, 0, 0);
  delay(2000);
  reader.drawBMP("/PIC_135240_8.bmp", tft, 0, 0);
  delay(2000);
  /*  for(int r=0; r<4; r++) { // For each of 4 rotations...
      tft.setRotation(r);    // Set rotation
      tft.fillScreen(0);     // and clear screen
  */
  // Load 4 copies of the 'parrot.bmp' image to the screen, some
  // partially off screen edges to demonstrate clipping. Globals
  // 'width' and 'height' were set by bmpDimensions() call in setup().
  /*    for(int i=0; i<4; i++) {
        reader.drawBMP("/parrot.bmp", tft,
          reader.drawBMP("/PIC2.bmp", tft,
          (tft.width()  * i / 3) - (width  / 2),
          (tft.height() * i / 3) - (height / 2));
  */

  //   }

  //   delay(1000); // Pause 1 sec.

  // Draw 50 Welsh dragon flags in random positions. This has no effect
  // on memory-constrained boards like the Arduino Uno, where the image
  // failed to load due to insufficient RAM, but it's NOT fatal.
  for (int i = 0; i < 50; i++) {
    // Rather than reader.drawBMP() (which works from SD card),
    // a different function is used for RAM-resident images:
    img.draw(tft,                                    // Pass in tft object
             (int16_t)random(-img.width() , tft.width()) ,  // Horiz pos.
             (int16_t)random(-img.height(), tft.height())); // Vert pos
    // Reiterating a prior point: img.draw() does nothing and returns
    // if the image failed to load. It's unfortunate but not disastrous.
  }

  delay(2000); // Pause 2 sec.
  // }

}

unsigned long testFillScreen() {
  unsigned long start = micros();
  //  tft.fillScreen(ILI9341_BLACK);
  //  yield();
  // delay(delay_Dis);
  tft.fillScreen(ST77XX_RED);
  // yield();
  delay(delay_Dis);
  tft.fillScreen(ST77XX_GREEN);
  // yield();
  delay(delay_Dis);
  tft.fillScreen(ST77XX_BLUE);
  // yield();
  delay(delay_Dis);
  //  tft.fillScreen(ST77XX_DARKGREY);  //2020/08/12,增加测试灰度
  // yield();
  // delay(delay_Dis);
  tft.fillScreen(ST77XX_BLACK);
  //  yield();
  delay(delay_Dis);

  tft.fillScreen(ST77XX_WHITE);
  //  yield();
  delay(delay_Dis);


  return micros() - start;
}

unsigned long testText() {
  tft.fillScreen(ST77XX_BLACK);
  unsigned long start = micros();
  tft.setCursor(0, 0);
  tft.setTextColor(ST77XX_WHITE);  tft.setTextSize(1);
  tft.println("Hello World!");
  tft.setTextColor(ST77XX_YELLOW); tft.setTextSize(2);
  tft.println(1234.56);
  tft.setTextColor(ST77XX_RED);    tft.setTextSize(3);
  tft.println(0xDEADBEEF, HEX);
  tft.println();
  tft.setTextColor(ST77XX_GREEN);
  tft.setTextSize(5);
  tft.println("Groop");
  tft.setTextSize(2);
  tft.println("I implore thee,");
  tft.setTextSize(1);
  tft.println("my foonting turlingdromes.");
  tft.println("And hooptiously drangle me");
  tft.println("with crinkly bindlewurdles,");
  tft.println("Or I will rend thee");
  tft.println("in the gobberwarts");
  tft.println("with my blurglecruncheon,");
  tft.println("see if I don't!");
  return micros() - start;
}

unsigned long testLines(uint16_t color) {
  unsigned long start, t;
  int           x1, y1, x2, y2,
                w = tft.width(),
                h = tft.height();

  tft.fillScreen(ST77XX_BLACK);
  yield();

  x1 = y1 = 0;
  y2    = h - 1;
  start = micros();
  for (x2 = 0; x2 < w; x2 += 6) tft.drawLine(x1, y1, x2, y2, color);
  x2    = w - 1;
  for (y2 = 0; y2 < h; y2 += 6) tft.drawLine(x1, y1, x2, y2, color);
  t     = micros() - start; // fillScreen doesn't count against timing

  yield();
  tft.fillScreen(ST77XX_BLACK);
  yield();

  x1    = w - 1;
  y1    = 0;
  y2    = h - 1;
  start = micros();
  for (x2 = 0; x2 < w; x2 += 6) tft.drawLine(x1, y1, x2, y2, color);
  x2    = 0;
  for (y2 = 0; y2 < h; y2 += 6) tft.drawLine(x1, y1, x2, y2, color);
  t    += micros() - start;

  yield();
  tft.fillScreen(ST77XX_BLACK);
  yield();

  x1    = 0;
  y1    = h - 1;
  y2    = 0;
  start = micros();
  for (x2 = 0; x2 < w; x2 += 6) tft.drawLine(x1, y1, x2, y2, color);
  x2    = w - 1;
  for (y2 = 0; y2 < h; y2 += 6) tft.drawLine(x1, y1, x2, y2, color);
  t    += micros() - start;

  yield();
  tft.fillScreen(ST77XX_BLACK);
  yield();

  x1    = w - 1;
  y1    = h - 1;
  y2    = 0;
  start = micros();
  for (x2 = 0; x2 < w; x2 += 6) tft.drawLine(x1, y1, x2, y2, color);
  x2    = 0;
  for (y2 = 0; y2 < h; y2 += 6) tft.drawLine(x1, y1, x2, y2, color);

  yield();
  return micros() - start;
}

unsigned long testFastLines(uint16_t color1, uint16_t color2) {
  unsigned long start;
  int           x, y, w = tft.width(), h = tft.height();

  tft.fillScreen(ST77XX_BLACK);
  start = micros();
  for (y = 0; y < h; y += 5) tft.drawFastHLine(0, y, w, color1);
  for (x = 0; x < w; x += 5) tft.drawFastVLine(x, 0, h, color2);

  return micros() - start;
}

unsigned long testRects(uint16_t color) {
  unsigned long start;
  int           n, i, i2,
                cx = tft.width()  / 2,
                cy = tft.height() / 2;

  tft.fillScreen(ST77XX_BLACK);
  n     = min(tft.width(), tft.height());
  start = micros();
  for (i = 2; i < n; i += 6) {
    i2 = i / 2;
    tft.drawRect(cx - i2, cy - i2, i, i, color);
  }

  return micros() - start;
}

unsigned long testFilledRects(uint16_t color1, uint16_t color2) {
  unsigned long start, t = 0;
  int           n, i, i2,
                cx = tft.width()  / 2 - 1,
                cy = tft.height() / 2 - 1;

  tft.fillScreen(ST77XX_BLACK);
  n = min(tft.width(), tft.height());
  for (i = n; i > 0; i -= 6) {
    i2    = i / 2;
    start = micros();
    tft.fillRect(cx - i2, cy - i2, i, i, color1);
    t    += micros() - start;
    // Outlines are not included in timing results
    tft.drawRect(cx - i2, cy - i2, i, i, color2);
    yield();
  }

  return t;
}

unsigned long testFilledCircles(uint8_t radius, uint16_t color) {
  unsigned long start;
  int x, y, w = tft.width(), h = tft.height(), r2 = radius * 2;

  tft.fillScreen(ST77XX_BLACK);
  start = micros();
  for (x = radius; x < w; x += r2) {
    for (y = radius; y < h; y += r2) {
      tft.fillCircle(x, y, radius, color);
    }
  }

  return micros() - start;
}

unsigned long testCircles(uint8_t radius, uint16_t color) {
  unsigned long start;
  int           x, y, r2 = radius * 2,
                      w = tft.width()  + radius,
                      h = tft.height() + radius;

  // Screen is not cleared for this one -- this is
  // intentional and does not affect the reported time.
  start = micros();
  for (x = 0; x < w; x += r2) {
    for (y = 0; y < h; y += r2) {
      tft.drawCircle(x, y, radius, color);
    }
  }

  return micros() - start;
}

unsigned long testTriangles() {
  unsigned long start;
  int           n, i, cx = tft.width()  / 2 - 1,
                      cy = tft.height() / 2 - 1;

  tft.fillScreen(ST77XX_BLACK);
  n     = min(cx, cy);
  start = micros();
  for (i = 0; i < n; i += 5) {
    tft.drawTriangle(
      cx    , cy - i, // peak
      cx - i, cy + i, // bottom left
      cx + i, cy + i, // bottom right
      tft.color565(i, i, i));
  }

  return micros() - start;
}

unsigned long testFilledTriangles() {
  unsigned long start, t = 0;
  int           i, cx = tft.width()  / 2 - 1,
                   cy = tft.height() / 2 - 1;

  tft.fillScreen(ST77XX_BLACK);
  start = micros();
  for (i = min(cx, cy); i > 10; i -= 5) {
    start = micros();
    tft.fillTriangle(cx, cy - i, cx - i, cy + i, cx + i, cy + i,
                     tft.color565(0, i * 10, i * 10));
    t += micros() - start;
    tft.drawTriangle(cx, cy - i, cx - i, cy + i, cx + i, cy + i,
                     tft.color565(i * 10, i * 10, 0));
    yield();
  }

  return t;
}

unsigned long testRoundRects() {
  unsigned long start;
  int           w, i, i2,
                cx = tft.width()  / 2 - 1,
                cy = tft.height() / 2 - 1;

  tft.fillScreen(ST77XX_BLACK);
  w     = min(tft.width(), tft.height());
  start = micros();
  for (i = 0; i < w; i += 6) {
    i2 = i / 2;
    tft.drawRoundRect(cx - i2, cy - i2, i, i, i / 8, tft.color565(i, 0, 0));
  }

  return micros() - start;
}

unsigned long testFilledRoundRects() {
  unsigned long start;
  int           i, i2,
                cx = tft.width()  / 2 - 1,
                cy = tft.height() / 2 - 1;

  tft.fillScreen(ST77XX_BLACK);
  start = micros();
  for (i = min(tft.width(), tft.height()); i > 20; i -= 6) {
    i2 = i / 2;
    tft.fillRoundRect(cx - i2, cy - i2, i, i, i / 8, tft.color565(0, i, 0));
    yield();
  }

  return micros() - start;
}
unsigned long testFrame(uint16_t color) {
  unsigned long start;
  int         //  n, i, i2,
  cx = tft.width() ,  // / 2,
  cy = tft.height() ; // / 2;

  tft.fillScreen(ST77XX_BLACK);
  //  n     = min(tft.width(), tft.height());
  start = micros();
  // for (i = 2; i < n; i += 6)
  {
    //   i2 = i / 2;
    //   tft.drawRect(cx - i2, cy - i2, i, i, color);
    tft.drawRect(0, 0, cx, cy, color);
  }

  return micros() - start;
}
unsigned long testGrayHor16() {
  //  unsigned int i,j,k;
  int  cx = tft.width() , cy = tft.height();
  //   unsigned int i,j,k,m,c;
  unsigned int gray16[] = {0x0000, 0x1082, 0x2104, 0x3186, 0x4208, 0x528a, 0x630c, 0x738e, 0x8410, 0x9492, 0xa514, 0xb596, 0xc618, 0xd69a, 0xe71c, 0xffff};
  //  unsigned int gray16[] = {0x0000, 0x1010, 0x2020, 0x3030, 0x4040, 0x5050, 0x6060, 0x7070, 0x8080, 0x9090, 0xa0a0, 0xb0b0, 0xc0c0, 0xd0d0, 0xe0e0, 0xf0f0, 0xffff};
  //16灰阶
  tft.fillScreen(ST77XX_BLACK);
  tft.fillRect(0, 0, cx, cy / 16 - 1, gray16[0]);
  tft.fillRect(0, cy / 16, cx, (cy / 16) * 2 - 1, gray16[1]);
  tft.fillRect(0, (cy / 16) * 2, cx, (cy / 16) * 3 - 1 , gray16[2]);
  tft.fillRect(0, (cy / 16) * 3, cx, (cy / 16) * 4 - 1, gray16[3]);
  tft.fillRect(0, (cy / 16) * 4, cx, (cy / 16) * 5 - 1, gray16[4]);
  tft.fillRect(0, (cy / 16) * 5, cx, (cy / 16) * 6 - 1, gray16[5]);
  tft.fillRect(0, (cy / 16) * 6, cx, (cy / 16) * 7 - 1, gray16[6]);
  tft.fillRect(0, (cy / 16) * 7, cx, (cy / 16) * 8 - 1, gray16[7]);
  tft.fillRect(0, (cy / 16) * 8, cx, (cy / 16) * 9 - 1, gray16[8]);
  tft.fillRect(0, (cy / 16) * 9, cx, (cy / 16) * 10 - 1, gray16[9]);
  tft.fillRect(0, (cy / 16) * 10, cx, (cy / 16) * 11 - 1, gray16[10]);
  tft.fillRect(0, (cy / 16) * 11, cx, (cy / 16) * 12 - 1, gray16[11]);
  tft.fillRect(0, (cy / 16) * 12, cx, (cy / 16) * 13 - 1, gray16[12]);
  tft.fillRect(0, (cy / 16) * 13, cx, (cy / 16) * 14 - 1, gray16[13]);
  tft.fillRect(0, (cy / 16) * 14, cx, (cy / 16) * 15 - 1, gray16[14]);
  tft.fillRect(0, (cy / 16) * 15, cx, (cy / 16) * 16 - 1, gray16[15]);

  //  tft.fillRect(0, 304, tft.width(), 319, gray16[16]);
}
unsigned long testBand() {
  unsigned int i, j, k, m, c;
  int  cx = tft.width() , cy = tft.height();
  unsigned int  color[8] = {0x001f, 0x07e0, 0xf800, 0x07ff, 0xf81f, 0xffe0, 0x0000, 0xffff};
  tft.fillScreen(ST77XX_BLACK);
  //  for (i = 0;i < 8;i++)

  // tft.fillScreen(color[i]);
  {
    //    for (j = 0;j < tft.height();j+=32)

    //    for (k = 0;k < tft.width();k++)
    //    for (i = 0;i < 8;i++)
    //     c=k*j+color[i];
    //32像素高显示彩色条
    tft.fillRect(0, 0, cx, cy / 8 - 1, color[0]);
    tft.fillRect(0, cy / 8, cx, (cy / 8) * 2 - 1, color[1]);
    tft.fillRect(0, (cy / 8) * 2, cx, (cy / 8) * 3 - 1, color[2]);
    tft.fillRect(0, (cy / 8) * 3, cx, (cy / 8) * 4 - 1, color[3]);
    tft.fillRect(0, (cy / 8) * 4, cx, (cy / 8) * 5 - 1, color[4]);
    tft.fillRect(0, (cy / 8) * 5, cx, (cy / 8) * 6 - 1, color[5]);
    tft.fillRect(0, (cy / 8) * 6, cx, (cy / 8) * 7 - 1, color[6]);
    tft.fillRect(0, (cy / 8) * 7, cx, (cy / 8) * 8 - 1, color[7]);


    /*     {
           tft.drawPixel(k,j,color[i]);
         }*/
    //   for (i = 0;i < 8;i++)
    //      SPI.transfer16(color[i]);

    //    }
  }
  for (j = 0; j < tft.height() % 8; j++)
  {
    for (k = 0; k < tft.width(); k++)
      tft.drawPixel(k, j, color[7]);
  }
}
