
#include "..\config.h"

#include "userDataProcess.h"

/*********************************************************************************************************
  
*********************************************************************************************************/
#define LED1        (1 << 0)                           // P2.0 is used to control LED1 
#define LED1OFF()   FIO2SET = LED1                     // LED1 off
#define LED1ON()    FIO2CLR = LED1                     // LED1 ON     

int main (void)
{
    INT8U demoFlag = 0;        // diaplay mode flag,   0-> contiually ;     1(non 0)-> freeze at current pic    
    INT8U picIndex = 0;        // index of demo pic   

    targetInit();                             // Target MCU initialization  
    pinInit();                                // MCU PIN initialization                                                                                  

    FIO2DIR |= LED1;                          // P2.0 is Output foot 
    keyInit();		                          // Initialize Key as input

	lcdPinInit();                             // Initialize RST, CD, RW, E as output
    lcdInit();                                // Initialize LCD controller
	
    cleanScreen();    // clean screen
	
    while (1) {
        
		if ((FIO2PIN & KEY1) == 0) {          // 
			
            if (demoFlag == 0) {
			    demoFlag = 1;
			}
			else {
			    demoFlag = 0;
			} 
	    } 
	    else {					              // 
            //Action Code
	    }
	  /*
        if ((FIO2PIN & KEY2) == 0) {          // 
            //Action Code
	    } 
		else {					              // 
            //Action Code
	    } 
	  */

	  /*
        LED1ON();
        delayMs(1000);
        LED1OFF();
        delayMs(1000);	

        fillScreenBySubArea(1,1,1);
        delayMs(1000);
        cleanScreen();
        delayMs(1000);
        
        fillScreenBySubArea(0,0,1);
        delayMs(1000);
        cleanScreen();
        delayMs(1000);

		refreshScreen(graphic_D0);
        delayMs(1000);
        cleanScreen();
        delayMs(1000);

		refreshScreen(graphic_D1);
        delayMs(1000);
        cleanScreen();
        delayMs(1000);

        refreshScreen(graphic_D2);
        delayMs(1000);
        cleanScreen();
        delayMs(1000);

		refreshScreen(graphic_D3);
        delayMs(1000);
        cleanScreen();
        delayMs(1000);

		refreshScreen(graphic_D4);
        delayMs(1000);
        cleanScreen();
        delayMs(1000);

		refreshScreen(graphic_D5);
        delayMs(1000);
        cleanScreen();
        delayMs(1000);
	   */
      	
		if (demoFlag == 0) {
		    picIndex++;
			if (picIndex>5) {
			    picIndex=0;
            }
            
            switch (picIndex) {
                case 0: {
                    cleanScreen();    // clean screen
                    refreshScreen(graphic_D0);
					break;
				}
				case 1: {
                    cleanScreen();    // clean screen
                    refreshScreen(graphic_D1);
					break;
				}  
				case 2: {
                    cleanScreen();    // clean screen
                    refreshScreen(graphic_D2);
					break;
				}  
				case 3: {
                    cleanScreen();    // clean screen
                    refreshScreen(graphic_D3);
					break;
				}
				case 4: {
                    cleanScreen();    // clean screen
                    refreshScreen(graphic_D4);
					break;
				}
				case 5: {
                    cleanScreen();    // clean screen
                    refreshScreen(graphic_D5);
					break;
				}
				
				default: break;
			}
		}

		delayMs(1500); 	 



    }
}

/*********************************************************************************************************
  End Of File
*********************************************************************************************************/
